/**
* \file: Server.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Baidu CarLife
*
* \author: P. Govindaraju / RBEB/GM / Pradeepa.Govindaraju@in.bosch.com
*
* \copyright (c) 2016 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/
#ifndef BDCLT_SERVER_H
#define BDCLT_SERVER_H
#include <map>
#include <string>

// baidu headers
#include <bdcl/UspiInputSource.h>
#include <bdcl/AoapTransport.h>
#include <mutex>              // std::mutex, std::unique_lock
#include <condition_variable> // std::condition_variable, std::cv_status

// bdcl header
#include "AditCoreSurrogateChannel.h"
#include "MediaAudioChannel.h"
#include "VrTtsAudioChannel.h"
#include "VrCaptureAudioChannel.h"
#include "NaviTtsAudioChannel.h"
#include "InputChannel.h"
#include "VideoChannel.h"
#include <bdcl/AilAudioSink.h>
#include <bdcl/AilAudioSource.h>

// local headers
#include <utility/Singleton.h>
#include <utils/IStoppable.h>
#include <utils/bdclLayerManager.h>
#include "BdclSmoketest.h"

#include <uspi/FeatureDiscoveryTypes.h>
#include <utils/GadgetLoader.h>
#include <utils/iAP2EANativeSession.h>

namespace adit { namespace bdcl {

// handles switching, transport and session creation
class Server : public adit::utility::Singleton<Server>, public IStoppable, public EventDispatcher
{
public:
    Server();
    ~Server();

    bool init(const std::string& inConfigPath, const std::string& inChannelNumber);
    bool cleanUp();


    bool switchDevice(uint32_t inVid, uint32_t inPid, std::string inSerial, aoapTransportInfo_t* outAoapTransportInfo);

    void authenticatonResult(void);
    bool createEndpoints();
    bool startSession(aoapTransportInfo_t inAoapTransportInfo);//for Android
    bool startSession(const char* wFileName, const char* rFileName); //for Apple EA Native mode

    void destroySession(void);
    void playbackFirstFrameRenderedCallback();
    void playbackStopCallback();
    void requestStop();
//baidu call backs.
    static void cmdCarlifeDataSubscribeDone(S_SUBSCRIBE_MOBILE_CARLIFE_INFO_LIST*);
    static void cmdNaviNextTurnInfo(S_NAVI_NEXT_TURN_INFO*);
    static void vrStatusModule (S_VR_STATUS_LIST*);
    static void cmdMdExit();
    static void cmdCarDataSubscribe(S_VEHICLE_INFO_LIST*);
    static void cmdCarDataSubscribeStart(S_VEHICLE_INFO_LIST* inCarInfo);
    static void cmdCarDataSubscribeStop(S_VEHICLE_INFO_LIST* inCarInfo);
    static void cmdRegisterFeatureConfigRequest();

    pthread_mutex_t sessionMutex;
    std::string channelNumber;
    bool sessionActive;
    S_STATISTICS_INFO mCarlifeStaticsInfo={"aditTarget", "1.0.0", 1, "", 0, 1, 0, ""};
    static S_FEATURE_CONFIG_LIST configList;
    S_FEATURE_CONFIG featureConfigFocusUI;
    static S_CAR_GPS myGpsData ;
    static S_MOBILE_CARLIFE_INFO carlifeInfo;
    static S_SUBSCRIBE_MOBILE_CARLIFE_INFO_LIST carlifeInfoList;
    static S_VEHICLE_INFO carInfo;
    static S_VEHICLE_INFO_LIST carInfoList;

    S_HU_INFO huInfo={};

    void sendVideoEncoder(bool inStatus);

private:
    CoreCallbackDealer* mCallbackDealer;
    AditCoreSurrogateChannel* coreChannel;
    VideoChannel* videoStream;
    MediaAudioChannel* medAudio;
    VrTtsAudioChannel* vrPlayback;
    NaviTtsAudioChannel* ttsAudio;
    VrCaptureAudioChannel* vrCapture;
    InputChannel* touchInput;
    bool isDestroySession;
    bool running;
    int mSwitchResult;

    bool miAP2EASessionRunning;
    std::string miAP2DeviceSerial;
    GadgetLoader mGadgetLoader;
    iAP2EANativeSession* miAP2Session;
    std::map<std::string, aoapTransportInfo_t> transportInfos;
    std::mutex mutBdclDestroy;


    std::condition_variable cvSendVideoEncoder;
    std::mutex mutSendVideoEncoder;
    bool sendVideoEncoderConditionalFlag;

//    shared_ptr<bdclLayerManager>   layerManager;// need to make it as shared pointer in the future
    bdclLayerManager *layerManager;
    static void *keyeventListener(void *arg);
    void removeDot (string& inStr, int len);
    bool is_teardown;
    bool thread_running;
    pthread_t keyevent_thread;
    bool configBdcl(void);
    void createKeyeventThread(void);
    void sendInitialMessages(void);
    bool layerManagerInit(void);

    void setFeatureConfig();

    void onAppleDeviceFound(std::shared_ptr<adit::uspi::DiscoveredDeviceUsb> inUsbDevice);
    void onAppleDeviceLost(std::shared_ptr<adit::uspi::DiscoveredDeviceUsb> inUsbDevice);
    void onAoapDeviceFound(std::shared_ptr<adit::uspi::DiscoveredDeviceUsb> inUsbDevice);
    void onAoapDeviceLost(std::shared_ptr<adit::uspi::DiscoveredDeviceUsb> inUsbDevice);
    void onDeviceSwitched(std::shared_ptr<adit::uspi::DiscoveredDeviceUsb> inUsbDevice);
    void onDeviceChanged(std::shared_ptr<adit::uspi::DiscoveredDeviceUsb> inUsbDevice);
    void onStartEANative(std::string wFile, std::string rFile);
    //todo do we need read/write file names for stop too?Hmm..Not really.
    void onStopEANative(std::string wFile, std::string rFile);

    //session related event dispatcher call.
    void onMDExit(std::string serial);
    void onAoapReadTimeOutError(std::string serial);
    void onDeviceError(adit::uspi::DiscoveryError inErrorCode);

    bool initEaSession(std::string inSerial);
    bool deinitEaSession();
    bool startEaSession();
    bool stopEaSession();

};

std::string to_string_server(adit::uspi::DeviceInfo& inVal);

} } /* namespace adit { namespace bdcl */
#endif
